/* Wiktor Zychla, 2003 */
using System;

namespace Example
{
  public class KolorKlasyAttribute : Attribute
  {
    public KolorKlasyAttribute( string kolor )
    {
      this.kolor = kolor;
    }
    public string Kolor
    {
      get { return kolor; }
    }

    string kolor;
  }

  [KolorKlasy( "zielony" )]
  public class Typ1
  {
  }

  [KolorKlasy( "niebieski" )]
  public class Typ2
  {
  }

  public class CMainForm 
  {   
    public static void Main()
    {
      Type type;

      // zbadaj Typ1
      type = typeof( Typ1 );
      foreach ( Attribute a in type.GetCustomAttributes( true ) )
      {
        KolorKlasyAttribute kolorKlasy = a as KolorKlasyAttribute;
        if ( kolorKlasy != null )
          Console.WriteLine( "Typ {0} ma kolor {1}", type.Name, kolorKlasy.Kolor ); 
      }       

      // zbadaj Typ2
      type = typeof( Typ2 );
      foreach ( Attribute a in type.GetCustomAttributes( true ) )
      {
        KolorKlasyAttribute kolorKlasy = a as KolorKlasyAttribute;
        if ( kolorKlasy != null )
          Console.WriteLine( "Typ {0} ma kolor {1}", type.Name, kolorKlasy.Kolor ); 
      }       
    }
  }
}
